﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace IsolineEditing
{

	public class MeshSegmentation
	{
		private List<int>[] segments = null;
		private int[] segmentIndex = null;

		public List<int>[] Segments
		{
			get { return segments; }
		}
		public int[] SegmentIndex
		{
			get { return segmentIndex; }
		}

		public MeshSegmentation(StreamReader sr)
		{
			int maxIndex = -1;
			List<int> segmentIndex = new List<int>(10000);
			while (sr.Peek() > -1)
			{
				string s = sr.ReadLine();
				int index = Int32.Parse(s);
				segmentIndex.Add(index);
				if (index > maxIndex)
					maxIndex = index;
			}

			segments = new List<int>[maxIndex];
			for (int i = 0; i < maxIndex; i++)
				segments[i] = new List<int>(16);

			for (int i = 0; i < segmentIndex.Count; i++)
				segments[segmentIndex[i] - 1].Add(i);

			this.segmentIndex = segmentIndex.ToArray();
		}
	}
}
