﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;

using MyGeometry;
using Tao.OpenGl;
using Tao.Platform.Windows;

using Emgu.CV;
using Emgu.CV.Structure;
using Emgu.CV.UI;
using System.Drawing.Imaging;

namespace i3_ImageManipulator
{
	public unsafe partial class ImageManipulator : IDisposable
	{
		// ----------------------------------------------------------------------------
		// 

		// load and save ultilities
		public void ReadImage(string filename)
		{
			this.image = new Image<Bgr, byte>(filename);
			this.imgwidth = this.image.Width;
			this.imgheight = this.image.Height;
			this.CreateGLTxture(this.image, layertxtid);
			this.parentview.SetBallBounds(this.imgwidth, this.imgheight);
			this.SetGLViewPort(this.imgwidth, this.imgheight);
		}
		public void SaveImage(string filename)
		{
			this.image.Save(filename);
		}
		public void SaveHexagons()
		{
			if (this.hexagons.Count > 0)
			{
				string filename = this.imagename + ".six";

				StreamWriter sw = new StreamWriter(filename);
				foreach (Polygon plg in this.hexagons)
				{
					foreach (Point2 pt in plg.points)
					{
						sw.Write(pt.pos.x + " " + pt.pos.y + " ");
					}
					sw.Write("\n");
				}
				sw.Close();
				Program.OutputText("Saved six points to " + filename,true);
			}

		}
		public bool ReadHexagons()
		{
			string filename = this.imagename + ".six";

			if (!File.Exists(filename))
			{
				Program.OutputText("failed to load six points ... need user annotation ...", true);
				return false;
			}

			StreamReader sr = new StreamReader(filename);
			if (this.hexagons == null) this.hexagons = new List<Polygon>();
			this.hexagons.Clear();
			char[] delimiters = { ' ', '\t' };
			string s = ""; string[] tokens;
			while (sr.Peek() > -1)
			{
				List<Point2> pts2 = new List<Point2>();
				s = sr.ReadLine(); // line 
				tokens = s.Split(delimiters);
				for (int i = 0, j = 0; i < 6; ++i, j += 2)
				{
					double x = double.Parse(tokens[j]);
					double y = double.Parse(tokens[j + 1]);
					pts2.Add(new Point2(new Vector2d(x, y)));
				}
				Polygon plg = new Polygon(pts2);
				this.hexagons.Add(plg);
			}
			sr.Close();

			Program.OutputText("loaded six points ... ",true);

			return true;
		}

		// initial entry
		public void Init()
		{
			this.ReadHexagons();
			return;
		}
	}
}