﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Xml.Serialization;
using MyGeometry;


namespace i3_ImageManipulator
{
    public partial class FormMain : Form
    {
        // constructor
        public FormMain()
        {
            InitializeComponent();

			this.corelatedbuttons.Add(toolStripButtonAdjustHexagon);
			this.corelatedbuttons.Add(toolStripButtonViewTool);
			this.corelatedbuttons.Add(toolStripButtonSelection);
			this.corelatedbuttons.Add(toolStripButtonOptimize);
			this.corelatedbuttons.Add(toolStripButtonAssignHexagon);
        }
        // NEW_ADD
        public ImageView GetimageView()
        {
            return imageView;
        }


		public void AddTabObject(ImageManipulator rec)
		{
			string filename = Path.GetFileName(rec.imagename);
			TabPage p = new TabPage(filename);
			p.Tag = rec;
			rec.TabIndex = (byte)this.tabControlMain.TabPages.Count;
			this.tabControlMain.TabPages.Add(p);
			this.tabControlMain.SelectedTab = p;
		}


        // event handlers
		private void FormMain_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
		{
		}
		private void FormMain_KeyUp(object sender, KeyEventArgs e)
		{
			switch (e.KeyData)
			{
				case Keys.F1:
					break;
				case Keys.F2:
                    this.imageView.CurrentMode = ImageView.EnumOperationMode.Viewing;
					break;
				case Keys.F3:
					
					break;
				case Keys.F4:
					
					break;
				case Keys.F5:
					
					break;
				case Keys.F6:
					
					break;
				case Keys.F7:
					
					break;
				case Keys.F8:
					
					break;
				case Keys.F9:
					
					break;
                case Keys.F10:
                    
                    break;
                
			}
		}
        private void FormMain_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyData)
            {
				case Keys.A:
					
					break;
				case Keys.S:
                    this.SetMode(ImageView.EnumOperationMode.Selection);
                    break;
				case Keys.D:
					
					break;
				case Keys.Space:
					this.SetMode(ImageView.EnumOperationMode.Viewing);
					break;
                case Keys.T:
					
                    break;
				case Keys.Delete:

					break;
            }
        }
		private void toolStripButtonOpenFile_Click(object sender, EventArgs e)
        {
            LoadImage();
        }
        private void LoadImage()
        {
            OpenFileDialog d = new OpenFileDialog();
            d.FileName = "";
            d.Filter = "Image File (*.jpg;*.png;*.bmp;*.tiff)|*.jpg;*.png;*.bmp;*.tiff|All files (*.*)|*.*";
            d.CheckFileExists = true;
            DialogResult ret = d.ShowDialog(this);

            if (ret == DialogResult.OK)
            {
                string fullPath = d.FileName;
                char[] delimiters = { '.' };
                string[] tokens = fullPath.Split(delimiters);

                string extension;
                if (tokens.Length > 0)
                    extension = tokens[tokens.Length - 1];
                else
                    extension = "obj";

                string filename = Path.GetFileName(fullPath);
                this.imagename = fullPath.Substring(0, fullPath.Length - 4);

                // load image
                ImageManipulator imgManipulator = new ImageManipulator();
				imgManipulator.parentview = this.imageView;
                imgManipulator.ReadImage(fullPath);
				imgManipulator.imagename = this.imagename;
				this.imageView.ImgManipulator = imgManipulator;
                imgManipulator.Init();
				Program.activeView = this.imageView;


                this.propertyGrid1.SelectedObject = imgManipulator;
				this.AddTabObject(imgManipulator);
				this.imageView.Refresh();
            }
        }
        private void toolStripButtonViewTool_Click(object sender, EventArgs e)
        {
            SetMode(ImageView.EnumOperationMode.Viewing);
        }
		private void toolStripButtonShowHideVertices_Click(object sender, EventArgs e)
		{
			
		}
		private void tabControlMain_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (this.tabControlMain.SelectedTab != null)
			{
				ImageManipulator rec = (ImageManipulator)this.tabControlMain.SelectedTab.Tag;
				this.imageView.ImgManipulator = rec;
				this.propertyGrid1.SelectedObject = rec;
			}
			else
			{
				this.imageView.ImgManipulator = null;
				this.propertyGrid1.SelectedObject = null;
			}
		}
		private void buttonCloseModel_Click(object sender, EventArgs e)
		{
			
		}
		private void buttonShowHideRightPanel_Click(object sender, EventArgs e)
        {
            this.splitContainer1.Panel2Collapsed =
                !this.splitContainer1.Panel2Collapsed;
        }
		private void buttonShowHideDownPanel_Click(object sender, EventArgs e)
		{
			this.splitContainer2.Panel2Collapsed =
				!this.splitContainer2.Panel2Collapsed;
		}
		private void buttonClearOutputText_Click(object sender, EventArgs e)
		{
			this.textBoxOutputText.Text = "";
		}
		private void buttonCopyOutputText_Click(object sender, EventArgs e)
		{
		}
		private void toolStripButtonAntialiasing_Click(object sender, EventArgs e)
		{
			if (this.imageView.ImgManipulator != null)
			{
				this.imageView.ImgManipulator.InitialCalibrate();
				this.imageView.Refresh();
			}
		}
		private void toolStripButtonRandomWalkSegmentation_Click(object sender, EventArgs e)
		{
			if (this.imageView.ImgManipulator != null)
			{
				this.imageView.ImgManipulator.SaveHexagons();
				this.imageView.Refresh();
			}
		}

        // private functions
		private string imagename = null;
		private void CreateIsolineSegmenter()

		{
			
		}
		private void CreateRandomWalkSegmenter()
		{
			
		}


		// public functions
		public void OutputText(string s, bool newLine)
		{
			if (newLine)
				this.textBoxOutputText.AppendText(s + System.Environment.NewLine);
			else
				this.textBoxOutputText.AppendText(s);
		}
		public void DisplayData(double[] data1, double[] data2, int index)
		{
			
			
		}
		public void SetSatus(string s)
		{
			this.toolStripStatusLabel1.Text = s;
		}

        private void PrevFP_Click(object sender, EventArgs e)
        {
			

        }

        private void NextFP_Click(object sender, EventArgs e)
        {
			
        }

        private void RefreshSegColor_Click(object sender, EventArgs e)
        {
            

        }

        private void toolStripButtonLoadCamera_Click(object sender, EventArgs e)
        {
			
        }

        private void toolStripButtonSaveCamera_Click(object sender, EventArgs e)
		{

		}

        private void toolStripButtonLoadSeg_Click(object sender, EventArgs e)
		{

		}

		private void runSegmentation_Click(object sender, EventArgs e)
		{
			
		}

		

		private void saveCurrCandidateGradient_Click(object sender, EventArgs e)
		{

		}

		private void saveSegmentation_Click(object sender, EventArgs e)
		{
			
		}

		private void loadSegmentation_Click(object sender, EventArgs e)
		{
			
		}


		private void buttonMatch_Click(object sender, EventArgs e)
		{
			
		}

		private void toolStripButtonXY_Click(object sender, EventArgs e)
		{
			
		}

		private void toolStripButtonYZ_Click(object sender, EventArgs e)
		{
			
		}

		private void toolStripButtonXZ_Click(object sender, EventArgs e)
		{
			
		}

		private void toolStripTest_Click(object sender, EventArgs e)
		{

		}

		private void runUpdateIsosegmentor_Click(object sender, EventArgs e)
		{
			
		}

		private void UpdateDescriptors_Click(object sender, EventArgs e)
		{

		}

        private void buttonShowHideDownPanel_Click_1(object sender, EventArgs e)
        {
            this.splitContainer2.Panel2Collapsed =
                !this.splitContainer2.Panel2Collapsed;
        }

        private void buttonShowHideRightPanel_Click_1(object sender, EventArgs e)
        {
            this.splitContainer1.Panel2Collapsed = 
                !this.splitContainer1.Panel2Collapsed;
        }

		private List<ToolStripButton> corelatedbuttons = new List<ToolStripButton>();
		public void SetMode(ImageView.EnumOperationMode mode)
		{
			foreach (ToolStripButton button in this.corelatedbuttons)
				button.Checked = false;
			imageView.CurrentMode = mode;
			switch (mode)
			{
				case ImageView.EnumOperationMode.AdjustHexagon:
					toolStripButtonAdjustHexagon.Checked = true;
					break;
				case ImageView.EnumOperationMode.Viewing:
					toolStripButtonViewTool.Checked = true;
					break;
				case ImageView.EnumOperationMode.AssignHexagon:
					toolStripButtonAssignHexagon.Checked = true;
					break;
				case ImageView.EnumOperationMode.Selection:
					toolStripButtonSelection.Checked = true;
					break;
			}

			this.imageView.ContextMenuStrip = null;
			this.imageView.Refresh();
		}

		private void buttonCreateWarpMesh_Click(object sender, EventArgs e)
		{

		}

		private void RefreshSegColor_Click_1(object sender, EventArgs e)
		{
		}

		private void updateWarpMesh_Click_1(object sender, EventArgs e)
		{
		}

		private void LoadSkeleton_Click(object sender, EventArgs e)
		{
		}

		private void toolStripButtonMatch_Click(object sender, EventArgs e)
		{
			SetMode(ImageView.EnumOperationMode.AdjustHexagon);
		}


		private void FitPrimitives_Click_1(object sender, EventArgs e)
		{

		}


		private void toolStripButtonManipulator_Click(object sender, EventArgs e)
		{
		}

		private void buttonCloseModel_Click_1(object sender, EventArgs e)
		{
			if (this.tabControlMain.TabCount == 0) return;
			ImageManipulator rec = (ImageManipulator)this.tabControlMain.SelectedTab.Tag;
			if (rec != null)
			{
				this.tabControlMain.TabPages.Remove(this.tabControlMain.SelectedTab);

				// update the tab index for all meshrecords
				int index = 0;
				foreach (TabPage page in this.tabControlMain.TabPages)
				{
					ImageManipulator r = (ImageManipulator)page.Tag;
					r.TabIndex = (byte)index++;
				}

		//		this.imageView.Close();
				this.imageView.Refresh();
				GC.Collect();
			}
			
		}

		private void buttonInitialWorldFrame_Click(object sender, EventArgs e)
		{
		}


		private void BindTextures_Click_1(object sender, EventArgs e)
		{
		}


		private void toolStripButton1_Click(object sender, EventArgs e)
		{

		}


		private void toolStripButtonCalibration_Click(object sender, EventArgs e)
		{

		}

		private void toolStripButtonOptimization_Click(object sender, EventArgs e)
		{
			
		}

		private void toolStripButtonSaveShadow_Click(object sender, EventArgs e)
		{
		}

		private void saveCamToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (this.imageView.ImgManipulator != null)
			{
				SaveFileDialog d = new SaveFileDialog();
				d.FileName = "";
				d.Filter = "ArcBall Transformation File (*.cam)|*.cam|All files (*.*)|*.*";
				DialogResult ret = d.ShowDialog(this);

				if (ret == DialogResult.OK)
				{
					this.imageView.SaveTransformation(d.FileName);
				}
			}
		}

		private void loadCamToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (this.imageView.ImgManipulator != null)
			{
				OpenFileDialog d = new OpenFileDialog();
				d.FileName = "";
				d.Filter = "ArcBall Transformation File (*.cam)|*.cam|All files (*.*)|*.*";
				d.CheckFileExists = true;
				DialogResult ret = d.ShowDialog(this);

				if (ret == DialogResult.OK)
				{
					this.imageView.LoadTransformation(d.FileName);
					this.imageView.Refresh();
				}
			}
		}



		private void toolStripButtonTranslation_Click(object sender, EventArgs e)
		{
			SetMode(ImageView.EnumOperationMode.AssignHexagon);
		}

		private void imageView_Load(object sender, EventArgs e)
		{

		}


		private void coplanarToolStripMenuItem1_Click(object sender, EventArgs e)
		{

		}


		private void toolStripButtonCopy_Click(object sender, EventArgs e)
		{

		}

		private void toolStripButtonPaste_Click(object sender, EventArgs e)
		{

		}

		private void toolStripButtonShadow_Click(object sender, EventArgs e)
		{
			
		}

		

		

		

		

		

		
    }
}
