﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using MyGeometry;
using Emgu.CV;
using Emgu.CV.Structure;
using Emgu.CV.UI;
 

namespace i3_ImageManipulator
{
	public class FittingJointOptimizer
	{
		private int multivariate = 1; // number of functions
		private double[] initialx = null;
		private List<List<Vector3d>> spacepoints = null;
		private List<List<Vector2d>> imgpoints = null;
		private List<Pair<int, int>> semanticconstraints = null;
		private int lefthand = 1;
		private bool optimizewithbox = false;
		private int initialindex = -1;
		
		// function and jacobi for single object calibrating (LM)
		private void function_single(double[] x, double[] funcs, object obj)
		{
			Matrix3d R = ImageManipulator.Angles2RotationRhs(x[3], x[4], x[5]);
			if (this.lefthand < 0)
			{
				R[0, 2] = -R[0,2];
				R[1, 2] = -R[1, 2];
				R[2, 2] = -R[2, 2];
			}
			// the camera matrix K[R|t]
			Matrix<double> K = new Matrix<double>(3, 3);
			K.SetZero();
			K[0, 0] = K[1, 1] = x[0]; K[2, 2] = 1.0;
			K[0, 2] = x[1]; K[1, 2] = x[2];
			Matrix<double> Rt = new Matrix<double>(3, 4);
			Rt.SetZero();
			for (int i = 0; i < 3; ++i)
			{
				for (int j = 0; j < 3; ++j)
				{
					Rt[i, j] = R[i, j];
				}
			}
			Rt[0, 3] = x[6];
			Rt[1, 3] = x[7];
			Rt[2, 3] = x[8];
			Matrix<double> M = K.Mul(Rt);
			Matrix<double> G = M;

			if (this.optimizewithbox)
			{
				int s = 9; int index = 0, functionindex = 0;
				foreach (List<Vector3d> spoints in this.spacepoints)
				{
					Matrix4d MM = ImageManipulator.GetBoxParameterMat(new double[6] {
						x[s], x[s+1], x[s+2], x[s+3], x[s+4], x[s+5]
					});
					s += 6;
					Matrix<double> Q = new Matrix<double>(4, 4);
					for (int i = 0; i < 4; ++i)
					{
						for (int j = 0; j < 4; ++j)
						{
							Q[i, j] = MM[i, j];
						}
					}
					G = M.Mul(Q);
					int jj = 0; List<Vector2d> ipoints = this.imgpoints[index];
					foreach (Vector3d p in spoints)
					{
						Matrix<double> p4 = new Matrix<double>(new double[4] { p.x, p.y, p.z, 1 });
						Matrix<double> T = G.Mul(p4);
						Vector3d res = new Vector3d(T[0, 0], T[1, 0], T[2, 0]);
				//		Vector2d ipt = res.HomogenousNormalize().ToVector2d();

						funcs[functionindex++] = T[0, 0] / T[2, 0] - ipoints[jj].x;
						funcs[functionindex++] = T[1, 0] / T[2, 0] - ipoints[jj].y;
						jj++;
					}
					index++;
				}
			}
			else
			{
				int index = 0, functionindex = 0;
				foreach (List<Vector3d> spoints in this.spacepoints)
				{
					List<Vector2d> ipoints = this.imgpoints[index++];
					int jj = 0;
					foreach (Vector3d p in spoints)
					{
						Matrix<double> p4 = new Matrix<double>(new double[4] { p.x, p.y, p.z, 1 });
						Matrix<double> T = G.Mul(p4);
						Vector3d res = new Vector3d(T[0, 0], T[1, 0], T[2, 0]);
				//		Vector2d ipt = res.HomogenousNormalize().ToVector2d();
						funcs[functionindex++] = T[0, 0] / T[2, 0] - ipoints[jj].x;
						funcs[functionindex++] = T[1, 0] / T[2, 0] - ipoints[jj].y;
						jj++;
					}
				}
			}
		}
		private void jacobi_single(double[] x, double[] funcvec, double[,] jac, object obj)
		{
			// this callback calculates the jacobi matrix of the function
			// E = f0^2 + f1^2 + f2^2 + ... 
			// energy term 1: \sum_i{||p_i-r*x1-(1-r)*x2||^2}
		//	this.function_single(x, funcvec, obj);


		}
		
		// function and jacobi matrix for multi-objects joint optimization (LM)
		private void function_joint(double[] x, double[] funcs, object obj)
		{
			Matrix3d R = ImageManipulator.Angles2RotationRhs(x[3], x[4], x[5]);
			if (this.lefthand < 0)
			{
				R[0, 2] = -R[0, 2];
				R[1, 2] = -R[1, 2];
				R[2, 2] = -R[2, 2];
			}
			// the camera matrix K[R|t]
			Matrix<double> K = new Matrix<double>(3, 3);
			K.SetZero();
			K[0, 0] = K[1, 1] = x[0]; K[2, 2] = 1.0;
			K[0, 2] = x[1]; K[1, 2] = x[2];
			Matrix<double> Rt = new Matrix<double>(3, 4);
			Rt.SetZero();
			for (int i = 0; i < 3; ++i)
			{
				for (int j = 0; j < 3; ++j)
				{
					Rt[i, j] = R[i, j];
				}
			}
			Rt[0, 3] = x[6];
			Rt[1, 3] = x[7];
			Rt[2, 3] = x[8];
			Matrix<double> M = K.Mul(Rt);
			Matrix<double> G = M;

			int s = 9; int index = 0, functionindex = 0;
			foreach (List<Vector3d> spoints in this.spacepoints)
			{
				Matrix4d MM = null;
				if (index == this.initialindex)
				{
					MM = ImageManipulator.GetBoxParameterMat(new double[6] {
						0, x[s], x[s+1], 1, 0, 0
					});
					s += 2;
				}
				else
				{
					MM = ImageManipulator.GetBoxParameterMat(new double[6] {
						x[s], x[s+1], x[s+2], x[s+3], x[s+4], x[s+5]
					});
					s += 6;
				}
				Matrix<double> Q = new Matrix<double>(4, 4);
				for (int i = 0; i < 4; ++i)
				{
					for (int j = 0; j < 4; ++j)
					{
						Q[i, j] = MM[i, j];
					}
				}
				G = M.Mul(Q);
				int jj = 0; List<Vector2d> ipoints = this.imgpoints[index];
				foreach (Vector3d p in spoints)
				{
					Matrix<double> p4 = new Matrix<double>(new double[4] { p.x, p.y, p.z, 1 });
					Matrix<double> T = G.Mul(p4);
					Vector3d res = new Vector3d(T[0, 0], T[1, 0], T[2, 0]);
					//		Vector2d ipt = res.HomogenousNormalize().ToVector2d();

					funcs[functionindex++] = T[0, 0] / T[2, 0] - ipoints[jj].x;
					funcs[functionindex++] = T[1, 0] / T[2, 0] - ipoints[jj].y;
					jj++;
				}
				index++;
			}

			// add semantic constraints here
			double semanticweight = 10;
			foreach (Pair<int, int> semantics in this.semanticconstraints)
			{
				int i = semantics.Item1, j = semantics.Item2;
				if (i == -1 && j != -1)
					funcs[functionindex] = semanticweight * (1 - x[j]);
				else if (j == -1 && i != -1)
					funcs[functionindex] = semanticweight * (1 - x[i]);
				else if (i != -1 && j != -1)
				{
					funcs[functionindex] = semanticweight * (x[i] - x[j]);
				}
				functionindex++;
			}

			//// ---
			//semanticweight *= 1000;
			//if (initialindex == 0)
			//{
			//    funcs[functionindex++] = semanticweight * (x[14] - 1);
			//    funcs[functionindex++] = semanticweight * (x[20] - 1);
			//}
			//else if (initialindex == 1)
			//{
			//    funcs[functionindex++] = semanticweight * (x[12] - 1);
			//    funcs[functionindex++] = semanticweight * (x[20] - 1);
			//}
			//else
			//{
			//    funcs[functionindex++] = semanticweight * (x[12] - 1);
			//    funcs[functionindex++] = semanticweight * (x[18] - 1);
			//}
		}
		private void jacobi_joint(double[] x, double[] funcvec, double[,] jac, object obj)
		{
			// this callback calculates the jacobi matrix of the function
			// E = f0^2 + f1^2 + f2^2 + ... 
			// energy term 1: \sum_i{||p_i-r*x1-(1-r)*x2||^2}
			this.function_joint(x, funcvec, obj);
			

		}

		public void Init(double[] initial, 
			List<List<Vector3d>> spacepts, List<List<Vector2d>> imgpts, List<Pair<int,int>> semanticconstraints, 
			int lefthanded, bool withbox)
		{
			int total = 0;
			foreach (List<Vector3d> point3 in spacepts)
			{
				total += point3.Count;
			}
			this.multivariate = total * 2 + semanticconstraints.Count; // 9 paramters for the camera
			this.initialx = initial;
			this.spacepoints = spacepts;
			this.imgpoints = imgpts;
			this.semanticconstraints = semanticconstraints;
			this.lefthand = lefthanded;
			this.optimizewithbox = withbox;
		}
		public double[] LMOptimize_Joint(int initindex)
		{
			//
			// This is the minimization of a nonlinear function 
			// F(x0,x1) = \sum_i{fi}^2
			// using "VJ" mode of the Levenberg-Marquardt optimizer.
			// -- Optimization algorithm uses: --
			// * function vector f[] = {...,f_i,...}
			// * Jacobian matrix J = {dfi/dxj}.
			//
			this.initialindex = initindex;
			double[] x = this.initialx;
			double epsg = 0.0000000001;
			double epsf = 0;
			double epsx = 0;
			int maxits = 10000;

			// first run
			alglib.minlmstate state;
			alglib.minlmreport rep;

			//// with jacobi
			//alglib.minlmcreatevj(this.multivariate, x, out state);
			//alglib.minlmsetcond(state, epsg, epsf, epsx, maxits);
			//alglib.minlmoptimize(state, function, jacobi, null, null);
			//alglib.minlmresults(state, out x, out rep);

			// without jacobi
			alglib.minlmcreatev(this.multivariate, x, 0.0001, out state);
			alglib.minlmsetcond(state, epsg, epsf, epsx, maxits);
			alglib.minlmoptimize(state, function_joint, null, null);
			alglib.minlmresults(state, out x, out rep);

			return x;
		}
		public double[] LMOptimize_Single()
		{
			//
			// This is the minimization of a nonlinear function 
			// F(x0,x1) = \sum_i{fi}^2
			// using "VJ" mode of the Levenberg-Marquardt optimizer.
			// -- Optimization algorithm uses: --
			// * function vector f[] = {...,f_i,...}
			// * Jacobian matrix J = {dfi/dxj}.
			//
			double[] x = this.initialx;
			double epsg = 0.0000000001;
			double epsf = 0;
			double epsx = 0;
			int maxits = 10000;

			// first run
			alglib.minlmstate state;
			alglib.minlmreport rep;

			//// with jacobi
			//alglib.minlmcreatevj(this.multivariate, x, out state);
			//alglib.minlmsetcond(state, epsg, epsf, epsx, maxits);
			//alglib.minlmoptimize(state, function, jacobi, null, null);
			//alglib.minlmresults(state, out x, out rep);

			// without jacobi
			alglib.minlmcreatev(this.multivariate, x, 0.0001, out state);
			alglib.minlmsetcond(state, epsg, epsf, epsx, maxits);
			alglib.minlmoptimize(state, function_single, null, null);
			alglib.minlmresults(state, out x, out rep);

			return x;
		}
	}
}
