/*----------3-16----------*/
#include   <stdio.h>
#include   <stdlib.h>
#include   <fcntl.h>
#include   <dos.h>
#include   <process.h>
#include   <bios.h>

/*ļͷṹ*/
typedef struct tagBITMAPFILEHEADER
{
    int     bfType;         /* ͨ 'BM' ƺжOS/2ıʶʲô*/
    long    bfSize;         /* ļСֽΪλ*/
    int     bfReserved1;    /*Ϊ0*/
    int     bfReserved2;    /*Ϊ0*/
    long    bfOffBits;      /*ļͷʼʵʵͼֽ֮ڵƫ*/
                            /*ǷǳõģΪλͼϢͷ͵ɫĳȻ*/
                            /*ݲͬ仯ƫֵѸٵĴļ*/
                            /*ȡλݡ */
} BITMAPFILEHEADER;

/*Ϣͷṹ*/
typedef struct tagBITMAPINFOHEADER
{
    long    biSize;             /* ϢͷС */
    long    biWidth;            /* ͼ */
    long    biHeight;           /* ͼ߶ */
    int     biPlanes;           /* Ϊ1 */
    int     biBitCount;         /* ÿλ1, 4, 824 */
    long    biCompression;      /* ѹ */
    long    biSizeImage;        /* ʵͼС4ı */
    long    biXPelsPerMeter;    /* ˮƽÿ */
    long    biYPelsPerMeter;    /* ֱÿ*/
    long    biClrUsed;          /* ɫ*/
    long    biClrImportant;     /* Ҫɫ */
} BITMAPINFOHEADER;

/*ɫ*/
typedef struct tagRGBQUAD
{
    char    rgbBlue;   /*ɫ*/
    char    rgbGreen;  /*ɫ*/
    char    rgbRed;    /*ɫ*/
    char    rgbReserved;
} RGBQUAD;


int COLS=640, ROWS=480;		/* ȱʡΪ256ɫ640*480ģʽ */

/*ҳ*/
void selectpage(register char page) 
{
	union REGS r;

	r.x.ax=0x4f05;
	r.x.bx=0;
	r.x.dx=page;            /*ѡҳ*/
	int86(0x10,&r,&r);
}

/*SVGAĻģʽ*/
/*101H----256ɫ640480ģʽ*/
/*103H----256ɫ800600ģʽ*/
/*105H----256ɫ1024768ģʽ*/
unsigned char set_SVGA_mode(int vmode)
{
	union REGS r;
	r.x.ax=0x4f02;
	r.x.bx=vmode;
	int86(0x10,&r,&r);
	return(r.h.ah);
}

/*ȡǰSVGAĻģʽ*/
unsigned int get_SVGA_mode()
{
	union REGS r;
	r.x.ax=0x4f03;
	int86(0x10,&r,&r);
	return(r.x.bx);
}

/*õɫ*/
void set_SVGA_palette(unsigned char r[],  unsigned char g[], unsigned char b[])
{
	int  k;
 	for (k = 0; k < 256; k++) {
  		outportb(0x03C8,k);
		outportb(0x03C9,r[k]>>2);
		outportb(0x03C9,g[k]>>2);
		outportb(0x03C9,b[k]>>2);
	}
}

void main()
{
     BITMAPFILEHEADER    FileHeader;
     BITMAPINFOHEADER    bmiHeader;
     RGBQUAD             bmiColors[256];
     unsigned char       buffer[1024], r[256], g[256], b[256];
     unsigned int	 width, height, linebytes;
     long		 offset, position;
     char page_new=0,page_old=0;
     int i,j,k,n,savemode;
     FILE *fp;

     printf("Input filename:");        /*ҪʾBMPļ·*/
     gets(buffer);

     if((fp=fopen(buffer,"rb"))==NULL) /*жϴļǷȷ*/
     {
	printf("Can't open file: %s",buffer);
	return;
     }

     if (fread((char *)&FileHeader, sizeof(FileHeader), 1, fp) != 1) {
        printf("Can't read file header !\n"); /* ļͷ */
        return;
     }
     if (FileHeader.bfType != 0X4D42) {  /* BM */
        fprintf(stderr, "Not a BMP file !\n");
        return;
     }

     if (fread((char *)&bmiHeader, sizeof(bmiHeader), 1, fp) != 1) {
        fprintf(stderr, "Can't read bmiHeader !\n");	/* Ϣͷ */
        return;
     }
     if (bmiHeader.biBitCount > 8) {	/* ʾɫͼ */
        fprintf(stderr, "Can not display ture color image !\n");
        return;
     }
     if (bmiHeader.biCompression != 0) { /* ܴѹͼ */
        fprintf(stderr, "Not non-compressed image !\n");
        return;
     }

     width = (unsigned int)bmiHeader.biWidth;
     height = (unsigned int)bmiHeader.biHeight;
     linebytes = ((width*(long)bmiHeader.biBitCount+31)/32)*4; /* ÿֽ--4 */

     if (fread((char *)&bmiColors[0], 4, 256, fp) != 256) { /* ɫ */
        fprintf(stderr, "Can't get palette !\n");
        return;
     }

     savemode=get_SVGA_mode(); /*ȱԭĻģʽ*/
     set_SVGA_mode(0x101); /*Ӳ޹ԳʼĻΪ256ɫ640*480ģʽ*/
     COLS=640;ROWS=480;
     for (i = 0; i < 256; i++) {
        r[i] = bmiColors[i].rgbRed;
        g[i] = bmiColors[i].rgbGreen;
        b[i] = bmiColors[i].rgbBlue;
     }
     set_SVGA_palette(r, g, b);	/* õɫ */

     offset = FileHeader.bfOffBits;
     fseek(fp, offset, SEEK_SET);    /* λͼݵʼλ */
     for(j=height-1;j>=0;j--) {
	fread(buffer,linebytes,1,fp);
	for(i=0,n=0;i<width;i++,n++) {
		position=j*(long)COLS+i; /*ҪʾԴλ*/
		page_new=position/65536l; /*ʾҳ*/
		if(page_new!=page_old) /*ʾҳͬʱҳ棬һٶ*/
		{
			selectpage(page_new);
			page_old=page_new;
		}
		pokeb(0xa000,position%65536l,buffer[n]); /*дԴλ*/
	}
     }
     fclose(fp);
     bioskey(0);
     set_SVGA_mode(savemode); /*ָĻ*/
}
/*----------3-16----------*/