#include "miner.h"

void MakeRect(SDL_Rect* rect, int x, int y, int w, int h)
{
	rect->x = x;
	rect->y = y;
	rect->w = w;
	rect->h = h;
}

int HitRectTest(int x, int y, SDL_Rect rect)
{
	return (x>=rect.x && y>=rect.y && x<rect.x+rect.w && y<rect.y+rect.h );
}
void * GetFocus()
{
	return theApp.pFocus;
}
void * SetFocus(void * pCtrl)
{
	theApp.pFocus = pCtrl;
	return pCtrl;
}

void* GetControlAt(int x, int y)
{
	if( HitRectTest(x,y,theApp.faceButton.rect) )
		return & theApp.faceButton;
	if( HitRectTest(x,y,theApp.mineField.rect) )
		return & theApp.mineField;
	return NULL;
}

SDL_Surface *load_image( char fname[] )
{
    //The image that's loaded
    SDL_Surface* loadedImage = NULL;

    //The optimized surface that will be used
    SDL_Surface* optimizedImage = NULL;

    //Load the image
    loadedImage = IMG_Load( fname );

    //If the image loaded
    if( loadedImage != NULL )
    {
        //Create an optimized surface
        optimizedImage = SDL_DisplayFormat( loadedImage );

        //Free the old surface
        SDL_FreeSurface( loadedImage );

        //If the surface was optimized
        if( optimizedImage != NULL )
        {
            //Color key surface
            SDL_SetColorKey( optimizedImage, SDL_SRCCOLORKEY, SDL_MapRGB( optimizedImage->format, 0, 0xFF, 0xFF ) );
        }
    }

    //Return the optimized surface
    return optimizedImage;
}


int LoadFiles()
{
	SDL_Surface *img;
	if( ! (img = load_image("..\\media\\430.bmp")) )
		return 0;
	theApp.imgFaces = img;

	if( ! (img = load_image("..\\media\\420.bmp")) )
		return 0;
	theApp.imgDigits = img;

	if( ! (img = load_image("..\\media\\410.bmp")) )
		return 0;
	theApp.imgBombs = img;

	theApp.nFaceSprite = 5;
	theApp.nDigitSprite = 12;
	theApp.nBombSprite = 16;

    return 1;
}


int FieldsWidth()
{
	return CellsWidth() * theApp.mineField.fldSize[0];
}
int FieldsHeight()
{
	return CellsHeight() * theApp.mineField.fldSize[1];
}
int DigitsWidth()
{
	return theApp.imgDigits->w;
}
int DigitsHeight()
{
	return theApp.imgDigits->h/theApp.nDigitSprite;
}
int FacesWidth()
{
	return theApp.imgFaces->w;
}
int FacesHeight()
{
	return theApp.imgFaces->h/theApp.nFaceSprite;
}
int CellsWidth()
{
	return theApp.imgBombs->w;
}
int CellsHeight()
{
	return theApp.imgBombs->h/theApp.nBombSprite;
}

int IsCell(void *p)
{
	MineField *fld = & theApp.mineField;
	void * plast = fld->pCells + fld->fldSize[2];
	return InRange(p, (void*)fld->pCells, plast);
}

Coord2D CellCoord(MineCell *p)
{
	MineField *fld = & theApp.mineField;
	Coord2D xy;
	int n = p - fld->pCells;
	xy.x = n % fld->fldSize[0];
	xy.y = n / fld->fldSize[0];
	return xy;
}

