#include "miner.h"

void onLButtonDown(void *pCtrl, int x, int y, unsigned char flags)
{
	if( pCtrl==&theApp.mineField && ! GameOver() )
	{
		postUserEvent(evtFaceOp);
		LeftPressField(x,y,flags);
	}
	else if( pCtrl==&theApp.faceButton )
	{
		theApp.faceButton.data = FaceSmileSink;
		Invalidate(& theApp.faceButton);
	}
}

void onLButtonUp(void *pCtrl, int x, int y, unsigned char flags)
{
	if( pCtrl==&theApp.faceButton )
	{
		postUserEvent(evtFaceSmile);
		postUserEvent(evtNewGame);
	}
	else if( pCtrl==&theApp.mineField  && ! GameOver() )
	{
		postUserEvent(evtFaceSmile);
		LeftReleaseField(x,y,flags);
	}
	SetFocus(NULL);
}

void onRButtonDown(void *pCtrl, int x, int y, unsigned char flags)
{
	if( pCtrl==&theApp.mineField  && ! GameOver() )
	{
		RightPressField(x,y,flags);
	}
}

void onRButtonUp(void *pCtrl, int x, int y, unsigned char flags)
{
	if( pCtrl==&theApp.mineField  && ! GameOver() )
	{
		postUserEvent(evtFaceSmile);
		RightReleaseField(x,y,flags);
	}	
}

void onMouseMove(void * pCtrl, int x, int y, unsigned char flags)
{
	void * pOld = GetFocus();

	if( pOld && pOld != pCtrl )
		LoseMouse(pOld);

	if ( ! pOld ) return; // no control to handle

	if( pOld==&theApp.mineField  && ! GameOver() )
		MoveOnField(x,y,flags);
}

void LoseMouse(void * pCtrl)
{
	if( pCtrl==&theApp.faceButton )
	{
		if( theApp.faceButton.data!=FaceSmile )
			postUserEvent(evtFaceSmile);
	}
}
