#include "miner.h"

#pragma comment(lib, "sdl.lib")
#pragma comment(lib, "sdlmain.lib")
#pragma comment(lib, "sdl_image.lib")
#pragma comment(lib, "sdl_gfx.lib")
//#pragma comment(lib, "sdl_ttf.lib")

MineApp theApp;

void CalcLayout()
{
	int w = theApp.screen->w;
	int h = theApp.screen->h;
	int w1 = DigitsWidth()*6 + FacesWidth();
	int w2 = FieldsWidth();
	int w3 = w2>w1 ? w2 : w1;
	int h1 = DigitsHeight() > FacesHeight() ? DigitsHeight() : FacesHeight();
	int h2 = FieldsHeight() + h1;
	int mgY = h>h2 ? (h-h2)/3 : 0;
	int mgX = w>w3 ? (w-w3)/2 : 0;

	MakeRect(& theApp.taskButton.rect, mgX, mgY, 
		DigitsWidth()*3, DigitsHeight());
	MakeRect(& theApp.timeButton.rect, w - mgX - DigitsWidth()*3, mgY, 
		DigitsWidth()*3, DigitsHeight());
	MakeRect(& theApp.faceButton.rect, w/2-FacesWidth()/2, mgY, 
		FacesWidth(), FacesHeight());
	MakeRect(& theApp.mineField.rect, mgX, mgY + h1 + mgY,
		FieldsWidth(), FieldsHeight());
	theApp.taskButton.rect.x += 3;
	theApp.timeButton.rect.x -= 3;
}

void InitMineField()
{
	GenerateRandomBombs(& theApp.mineField);
	CalcNeighbors(& theApp.mineField);
	theApp.mineField.cellSize[0] = CellsWidth();
	theApp.mineField.cellSize[1] = CellsHeight();
	theApp.mineField.state = sNewGame;
	theApp.mineField.pFocus = NULL;
}

int InitApp(int argc, char* args[])
{
	// configurations
	int fldSizeX = 30;
	int fldSizeY = 16;
	int bombCount= 99;
	// small for debuging
	//int fldSizeX = 10;
	//int fldSizeY = 6; 
	//int bombCoun = 5; 
	int mm = 16; // margin size
	int sz = 16; // bomb size
	int h1 = 25; // first row height
	int	w = mm*2 + fldSizeX * sz;
	int h = mm*3 + h1 + fldSizeY * sz;

	memset(&theApp, 0, sizeof(theApp));
	if( !ConstructField(&theApp.mineField, fldSizeX, fldSizeY, bombCount) )
		return 0;
	
	// Initialize all SDL subsystems
    if( SDL_Init( SDL_INIT_EVERYTHING ) == -1 )
    {
		printf("Failed to initialize SDL\n");
		return 0;
	}
    // Set up the screen
	theApp.screen = SDL_SetVideoMode( w, h, 32, SDL_HWSURFACE );
    // If there was an error in setting up the screen
    if( theApp.screen==NULL )
	{
		printf("Failed to create screen surface\n");
        return 0;
	}
    SDL_WM_SetCaption( "Miner", NULL );
    //Fill the screen back ground
	SDL_FillRect( theApp.screen, &theApp.screen->clip_rect, 
		SDL_MapRGB( theApp.screen->format, 186, 186, 186 ) );
    // Load the files
    if( ! LoadFiles() )
	{
		printf("Failed in loading files\n");
        return 0;
	}
	// set the rect for the buttons and the mine field
	CalcLayout();
	DrawFrames();
	// some data and status
	if( SDL_Flip( theApp.screen ) == -1 )
		return 0;

	postUserEvent(evtNewGame);

	return 1;
}

int CleanApp()
{
	SDL_FreeSurface( theApp.imgBombs );
	SDL_FreeSurface( theApp.imgFaces );
	SDL_FreeSurface( theApp.imgDigits );
	SDL_Quit();

	DestroyField(&theApp.mineField);

	return 1;
}

int main( int argc, char* args[] )
{
	if( ! InitApp(argc, args) )
		return (-1);
	RunApp();
	CleanApp();
    return 0;
}