#include "miner.h"


void postUserEvent(int code)
{
	// construct and initialise the UserEvent
	SDL_UserEvent ev;
	ev.type = SDL_USEREVENT;
	ev.code = code;
	ev.data1 = NULL;
	ev.data2 = NULL;
	//push it in the Event queue
	SDL_PushEvent((SDL_Event*)&ev);
}

Uint32 onTimer(Uint32 interval, void *param)
{
	// increment the right control
	theApp.timeButton.data++;
	// repaint it
	Invalidate( & theApp.timeButton);
	// chck th etime elapsed
	if( theApp.timeButton.data>=999 )
	{
		// if we are over 10000 stothe timer
		SDL_RemoveTimer(theApp.timerID);
		theApp.timerID = NULL;
	}
	// continue to receive the timer events on the same time interval (1s)
	return interval;
}

void onUserEvent( SDL_UserEvent *pEvent )
{
	// chck the user event code
	switch (pEvent->code)
	{
	case evtFaceOp:
		// change the face to 'o' image -> lbtn down
		theApp.faceButton.data = FaceOp;
		Invalidate(&theApp.faceButton);
		break;
	case evtFaceSmile:
		// change the face back to 'smile' -> lbtn up
		theApp.faceButton.data = FaceSmile;
		Invalidate(&theApp.faceButton);
		break;
	case evtMarkMore:
		// decrease the mine count
		theApp.taskButton.data--;
		Invalidate(&theApp.taskButton);
		break;
	case evtMarkLess:
		// increase the mine count
		theApp.taskButton.data++;
		Invalidate(&theApp.taskButton);
		break;
	case evtStartTimer:
		// start the timer when the newgame begins
		theApp.timerID = SDL_AddTimer(1000, onTimer, NULL);
		break;
	case evtNewGame: // new game
		SDL_RemoveTimer(theApp.timerID);
		theApp.timerID = NULL;
		InitMineField();
		theApp.timeButton.data = 0;
		theApp.taskButton.data = theApp.mineField.bombCount;
		theApp.faceButton.data = FaceSmile;
		// repaint all the controls
		Invalidate(&theApp.mineField);
		Invalidate(&theApp.faceButton);
		Invalidate(&theApp.timeButton);
		Invalidate(&theApp.taskButton);
		break;
	case evtStopTimer:
		// stop the timer
		SDL_RemoveTimer(theApp.timerID);
		theApp.timerID = NULL;
		break;
	case evtGameFail:
	case evtGameWin:
		theApp.mineField.state = sGameOver;
		Invalidate(&theApp.mineField);
		theApp.faceButton.data = ( pEvent->code==evtGameWin ? FaceGlass : FaceFail );
		Invalidate(&theApp.faceButton);
		break;
	}
}

void routeEvent(SDL_Event* event)
{
	SDL_MouseButtonEvent* mb = (SDL_MouseButtonEvent*)event;
	SDL_MouseMotionEvent* mm = (SDL_MouseMotionEvent*)event;
	SDL_QuitEvent ev;
	void *pNow;
	int  key;

	switch( event->type )
	{
	case SDL_MOUSEBUTTONDOWN: // mouse button down event
		pNow = GetControlAt(mb->x, mb->y);
		if( !pNow ) break;
		SetFocus(pNow);
		if ( mb->button == 1 )
			onLButtonDown(pNow, mb->x, mb->y, mb->state);
		else
			onRButtonDown(pNow, mb->x, mb->y, mb->state);
		break;
	case SDL_MOUSEBUTTONUP: // mouse button down event
		pNow = GetControlAt(mb->x, mb->y);
		if( ! pNow || pNow!=GetFocus() ) break;
		if ( mb->button == 1 )
			onLButtonUp(pNow, mb->x, mb->y, mb->state);
		else
			onRButtonUp(pNow, mb->x, mb->y, mb->state);
		break;

	case SDL_MOUSEMOTION: // mouse button down event
		pNow = GetControlAt(mm->x, mm->y);
		onMouseMove(pNow, mm->x, mm->y, mm->state);
		break;

	case SDL_KEYDOWN:
		key = event->key.keysym.sym;
		// check for escape
		if( key==SDLK_ESCAPE )
		{
			ev.type = SDL_QUIT;
			// post Quit event
			SDL_PushEvent( (SDL_Event*)&ev );
		}
		break;

	default:
		if( event->type >= SDL_USEREVENT && event->type < SDL_NUMEVENTS )
			onUserEvent((SDL_UserEvent*)event);
		break;
	}
}

int RunApp()
{
	int done = 0;
	SDL_Event event;

	// until we are ok
	while( !done)
	{
		// performany background processing 
		// onIdle();
		// check for SDL event in the queue
		while( SDL_PollEvent(&event) )
		{
			switch (event.type)
			{
			case SDL_QUIT:
				done = 1;
				break;
			default:
				routeEvent(&event);
				break;
			}
		}
		if( MissionCompleted() )
		{
			postUserEvent(evtStopTimer);
			postUserEvent(evtGameWin);
		}
		//Update the screen
        //if( SDL_Flip( theApp.screen ) == -1 )
        //    return 0;
	}

	return 1;
}

