#include "miner.h"

// lock the screen for writing
int scrlock()
{
	// using the SDL primitives
	if(SDL_MUSTLOCK(theApp.screen))
	{
		// lock it
		if ( SDL_LockSurface(theApp.screen) < 0 )
		{
			printf("Couldn't lock display surface: %s\n", SDL_GetError());
			return -1;
		}
	}
	return 0;
}

// unlock the  screen
void scrunlock(SDL_Rect *rect)
{
	// unlock it
	if(SDL_MUSTLOCK(theApp.screen))
		SDL_UnlockSurface(theApp.screen);
	if( rect )
		SDL_UpdateRect(theApp.screen, rect->x, rect->y, rect->w, rect->h);
	else
		SDL_UpdateRect(theApp.screen, 0, 0, 0, 0);
}

SDL_Rect draw_cell(int x, int y, int visualIndex)
{
	SDL_Surface *img = theApp.imgBombs;
	MineField * fld = & theApp.mineField; 
	SDL_Rect srcRect, offset = {0,0,0,0};
	int w = CellsWidth();
	int h = CellsHeight();

	MyDebug(
		if(!InRange(visualIndex,0,theApp.nBombSprite)) 
		{
			printf("Wrong visual index (%d)\n", visualIndex);
			return offset;
		})

	MakeRect(&srcRect, 0, h*visualIndex, w, h);
	MakeRect(&offset, fld->rect.x + x * w, fld->rect.y + y * h, w, h);
	SDL_BlitSurface(img, &srcRect, theApp.screen, &offset );
	return offset;
}

SDL_Rect DrawCell(MineCell *p)
{
	Coord2D c = CellCoord(p);
	return draw_cell(c.x, c.y, CellVisualIndex(*p));
}

void DrawFaceButton(ImageButton *b)
{
	SDL_Rect srcRect;
	int h =  FacesHeight();

	MakeRect( &srcRect, 0, h*b->data, FacesWidth(), h);
	SDL_BlitSurface(theApp.imgFaces, &srcRect, theApp.screen, &b->rect );
}

void DrawDigitButton(ImageButton *b)
{
	int g[3] = { b->data%1000/100, b->data%100/10, b->data%10 }, k;
	SDL_Rect srcRect, offset;

	MakeRect(&srcRect, 0, 0, DigitsWidth(), DigitsHeight());
	for( k=0; k<3; k++ )
	{
		srcRect.y = (theApp.nDigitSprite-1-g[k])*srcRect.h;
		offset.x = b->rect.x + k*srcRect.w;
		offset.y = b->rect.y;
		SDL_BlitSurface( theApp.imgDigits, &srcRect, theApp.screen, &offset );
	}
}

SDL_Rect DrawObject(void *p)
{
	if( IsCell(p) )
		return DrawCell(p);
	else if( p==(void*)&theApp.faceButton )
	{
		DrawFaceButton(&theApp.faceButton);
		return theApp.faceButton.rect;
	}
	else if( p==(void*)&theApp.timeButton )
	{
		DrawDigitButton(&theApp.timeButton);
		return theApp.timeButton.rect;
	}
	else if( p==(void*)&theApp.taskButton )
	{
		DrawDigitButton(&theApp.taskButton);
		return theApp.taskButton.rect;
	}
	else if( p==(void*)&theApp.mineField )
	{
		DrawField(& theApp.mineField);
		return theApp.mineField.rect;
	}

	printf("bad object to draw\n");
	// TODO: warning C4715: 'DrawObject' : not all control paths return a value
}

void Invalidate(void* b)
{
	SDL_Rect rect;
	// try to lock the screen
	while(scrlock() < 0)
		; // do nothing;
	// repaint control
	rect = DrawObject(b);
	// unlock and update the screen
	scrunlock(&rect);
}

void InvalidateCellList(MineCell *p[], int n)
{
	while( n-->0 ) Invalidate(p[n]);
}

void DrawField(MineField *fld)
{
	MineCell * p = fld->pCells;
	int NX = fld->fldSize[0];
	int NY = fld->fldSize[1];
	int s = fld->state;
	int x, y, vid = 0;

	for( x=0; x<NX; x++ ) for( y=0; y<NY; y++ )
	{
		if( s==sNewGame )
			vid = 0;
		else if( s==sGameOver )
			vid = CellFinalVisualIndex(p[x+y*NX]);
		else 
			vid = CellVisualIndex(p[x+y*NX]);
		draw_cell(x,y,vid);
	}
}


void DrawBumpRect(Sint16 x1, Sint16 y1, Sint16 x2, Sint16 y2, Sint16 thick, Uint8 dark, Uint8 bright)
{
	Sint16 k;
	for( k=0; k<thick; k++ )
	{
		hlineRGBA(theApp.screen, x1+k, x2-k, y1+k, dark, dark, dark, 255);
		vlineRGBA(theApp.screen, x1+k, y1+k, y2-k, dark, dark, dark, 255);

		hlineRGBA(theApp.screen, x1+k, x2-k, y2-k, bright, bright, bright, 255);
		vlineRGBA(theApp.screen, x2-k, y1+k, y2-k, bright, bright, bright, 255);
	}
}

void DrawFrames()
{
	Sint16 x1, y1, x2, y2;
	Sint16 ext=3, thick=3;
	Uint8 g1 = 130;
	Uint8 g2 = 250;

	x1 = theApp.mineField.rect.x - ext;
	x2 = theApp.mineField.rect.x + theApp.mineField.rect.w + ext;
	// bottom rect 
	y1 = theApp.mineField.rect.y - ext;
	y2 = theApp.mineField.rect.y + theApp.mineField.rect.h + ext;
	DrawBumpRect(x1,y1,x2,y2, thick, g1, g2);
	// top rect
	y1 = theApp.taskButton.rect.y - ext-5;
	y2 = theApp.taskButton.rect.y + theApp.taskButton.rect.h + ext+5;
	DrawBumpRect(x1,y1,x2,y2, thick, g1, g2);
	// small rect around task and time button
	ext = 2;
	thick = 2;
	y1 = theApp.taskButton.rect.y - ext;
	y2 = theApp.taskButton.rect.y + theApp.taskButton.rect.h + ext;
	// rect around task
	x1 = theApp.taskButton.rect.x - ext;
	x2 = theApp.taskButton.rect.x + theApp.taskButton.rect.w + ext;
	DrawBumpRect(x1,y1,x2,y2, thick, g1, g2);
	// rect around time
	x1 = theApp.timeButton.rect.x - ext;
	x2 = theApp.timeButton.rect.x + theApp.timeButton.rect.w + ext;
	DrawBumpRect(x1,y1,x2,y2, thick, g1, g2);
}
