# 3D Cross Field Generation by Jiong CHEN

This is an implementation of paper 'Boundary Aligned Smooth 3D
Cross-Frame Field'. The binaries are compiled on Linux with gcc 4.8.4.
It has been tested on Ubuntu 14.04 and Mint 17.3.

The project contains two separate executables, `test_vol_frame` and
`frame_field` under the folder of 'bin'.  The dependences of these
executables are in folders '3rd' and 'sys'.

The first executable takes a 3D tetrahedral mesh in **vtk** format as
input, and outputs a text file `zyz.txt` that includes the frames
defined *on each tetrahedron*. In my implementation, the frame is
denoted by its ZYZ angle. The specific format of the output is:

	3 N
	a1 b1 c1
	a2 b2 c2
	...
	aN bN cN
	
where N is the number of tetrahedra. The frame in matrix form is then
writen as `R_z(ci)*R_y(bi)*R_x(ai)`. The main parameters include the
weights of energy terms for the smoothness and boudary
alignment. Besides, the convergence tolerance (relative error of
energy value) and maximum number of iterations for LBFGS optimization
are provided for control.

The second executable takes `zyz.txt` as input and extracts the 
singularties of the cross field and dump them to a vtk file, which 
could be visualized by the free software `paraview`.

To run the demo, enter the folder 'bin', and run the script
'run_volume_frame.sh'. The detailed usage can be found in the script.
The output includes the frame field (x.vtk, y.vtk and z.vtk) and
singularity (sing.vtk).

In the folder of 'src', I put the maxima script about the computation
of SH.  Run it with maxima, and then you can evaluate the derivatives
of the terms, and turn them into fortran by maxima's f90 function. The
f90 files are also in the folder. With the fortran code at hand, you
can build the whole system without much difficulty in your own way.

Jiong CHEN (chenjiong1991@126.com)

2017 July 19
