#!/bin/bash

export LD_LIBRARY_PATH=../3rd:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=../sys:$LD_LIBRARY_PATH

echo -e "# ================================== Run cross frame field ======================================== #"
EXE=./test_vol_frame
MESH=../dat/sphere.c13k.vtk
WS=1e0
WA=1e3
EPS=1e-8
MAXITS=2000
OUT_DIR=../dat/sphere-ws$WS-wa$WA

if [ ! -d "$OUT_DIR" ]; then
    mkdir -p $OUT_DIR
fi

$EXE -i $MESH -t vtk -o $OUT_DIR --ws=$WS --wa=$WA --epsf=$EPS --maxits=$MAXITS | tee LOG.txt


echo -e "# ============================== Visualize sigularity of frame field ============================== #"
cd ../bin

FF_EXE=./frame_field
MESH_FILE=$OUT_DIR/tet.vtk
ZYZ_FILE=$OUT_DIR/zyz.txt
SING_FILE=$OUT_DIR/sing.vtk

$FF_EXE prog=draw_3d_frame_sing tet=$MESH_FILE zyz=$ZYZ_FILE out=$SING_FILE

echo -e "# ================================================================================================= #"
