#pragma once

#include "Vector3.h"
#include "Matrix.h"
#include "ZImage.h"

class CVideoFrame
{
public:
	CVideoFrame(void);
	~CVideoFrame(void);


public:
	void PrintParameters();

	void LoadColorImage();

	void LoadDepthImg();

	CVector3 CameraCoordToWorldCoord(CVector3& pt3d);

public:
	int m_iNo;
	int m_iWidth;
	int m_iHeight;
	std::string m_sImgName;
	std::string m_sDepthName;

	CMatrix3d m_K; //Intrinsic Matrix
	CMatrix3d m_R; //Rotational Matrix
	CVector3 m_T;  //Translation Vector

	ZByteImage m_ColorImg;
	ZFloatImage m_DspImg;//Inverse Depth Image
};
