#pragma once

class CVector3
{
public:
	CVector3(void);
	~CVector3(void);

public:

	double operator[] (int i) const{
		return m_data[i];
	}

	double& operator[] (int i) {
		return m_data[i];
	}

	double X() const{
		return m_data[0];
	}

	double& X() {
		return m_data[0];
	}

	double Y() const{
		return m_data[1];
	}

	double& Y() {
		return m_data[1];
	}

	double Z() const{
		return m_data[2];
	}

	double& Z() {
		return m_data[2];
	}

	CVector3 operator+ (const CVector3& rkV) const{
		CVector3 kSum;
		for(int i=0; i<3; ++i){
			kSum.m_data[i] = m_data[i] + rkV.m_data[i];
		}
		return kSum;
	}

	CVector3 operator- (const CVector3& rkV) const{
		CVector3 kSum;
		for(int i=0; i<3; ++i){
			kSum.m_data[i] = m_data[i] - rkV.m_data[i];
		}
		return kSum;
	}

	CVector3 operator* (const double fScalar) const{
		CVector3 kProd;
		for(int i=0; i<3; ++i){
			kProd.m_data[i] = fScalar * m_data[i];
		}
		return kProd;
	}

	CVector3 operator/ (const double fScalar) const{
		CVector3 kQuot;
		double fInvScalar = 1.0/fScalar;
		for(int i=0; i<3; ++i){			
			kQuot.m_data[i] = fInvScalar * m_data[i];
		}
		return kQuot;
	}

protected:
	double m_data[3];
};
