// UsingVIPSDlg.cpp : implementation file
//

#include "stdafx.h"
#include "UsingVIPS.h"
#include "UsingVIPSDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUsingVIPSDlg dialog

CUsingVIPSDlg::CUsingVIPSDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUsingVIPSDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUsingVIPSDlg)
	m_Url = _T("");
	m_iPDOC = 5;
	m_strOut = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUsingVIPSDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUsingVIPSDlg)
	DDX_Text(pDX, IDC_EDIT_URL, m_Url);
	DDX_Text(pDX, IDC_EDIT_PDOC, m_iPDOC);
	DDV_MinMaxInt(pDX, m_iPDOC, 1, 10);
	DDX_Control(pDX, IDC_EXPLORER1, m_webBrowser);
	DDX_Text(pDX, IDC_EDIT_OUT, m_strOut);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUsingVIPSDlg, CDialog)
	//{{AFX_MSG_MAP(CUsingVIPSDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_LOAD, OnLoadUrl)
	ON_BN_CLICKED(IDC_BUTTON_VIPSXML, OnVipsOutXML)
	ON_BN_CLICKED(IDC_BUTTON_VIPSTEXT, OnVipsOutText)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUsingVIPSDlg message handlers

BOOL CUsingVIPSDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	HRESULT hr = m_pLayoutAnalyzer.CreateInstance(CLSID_LayoutAnalyzer2);
	_ASSERT(SUCCEEDED(hr));
	m_pLayoutAnalyzer->Initialize(0);

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUsingVIPSDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUsingVIPSDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUsingVIPSDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUsingVIPSDlg::OnLoadUrl() 
{
	UpdateData(TRUE);

	if (m_Url.GetLength() == 0)
		return;

	m_webBrowser.Navigate(m_Url, NULL, NULL, NULL, NULL);
	
}

void CUsingVIPSDlg::OnVipsOutXML() 
{
	//if (m_webBrowser.GetReadyState() != READYSTATE_COMPLETE)
	//	return;

	//Get the document
	MSHTML::IHTMLDocument2Ptr pHTMLDoc = m_webBrowser.GetDocument();

	m_pLayoutAnalyzer->Analyze4(pHTMLDoc,_variant_t((long)m_iPDOC));

	MSXML2::IXMLDOMDocumentPtr pFOMPage = m_pLayoutAnalyzer->GetFOMPage();

	pFOMPage->save("VIPSResult.xml");

	m_strOut = "The XML Result saved 'VIPSResult.xml'";

	UpdateData(FALSE);
	
}

void CUsingVIPSDlg::OnVipsOutText() 
{
	MSHTML::IHTMLDocument2Ptr pHTMLDoc = m_webBrowser.GetDocument();

	m_pLayoutAnalyzer->AnalyzeOutputAll_Text(pHTMLDoc,_variant_t((long)m_iPDOC));

	_bstr_t strResult = m_pLayoutAnalyzer->getResult();

	m_strOut = (char*)strResult;

	UpdateData(FALSE);

}
